<?php

namespace App\Controllers;

use App\Models\TrainingModel;

class TrainingController extends BaseController
{
    protected $trainingModel;

    public function __construct()
    {
        $this->trainingModel = new TrainingModel();
    }

    public function index()
    {
        $search = $this->request->getGet('search') ?? '';
        $filter = [
            'penyelenggara' => $this->request->getGet('penyelenggara') ?? '',
            'tanggal_mulai' => $this->request->getGet('tanggal_mulai') ?? '',
            'tanggal_selesai' => $this->request->getGet('tanggal_selesai') ?? ''
        ];
        $sort = $this->request->getGet('sort') ?? 'urutan';
        $order = $this->request->getGet('order') ?? 'ASC';
        $page = (int)($this->request->getGet('page') ?? 1);

        $builder = $this->trainingModel->searchAndFilter($search, $filter, $sort, $order);
        $total = $builder->countAllResults(false);
        
        $perPage = 10;
        $training = $builder->get($perPage, ($page - 1) * $perPage)->getResultArray();

        $pager = \Config\Services::pager();
        $pager->store('training', $page, $perPage, $total);
        
        // Calculate last page manually to ensure it works
        $lastPage = (int) ceil($total / $perPage);

        $data = [
            'title' => 'Pelatihan - Portfolio',
            'training' => $training,
            'pager' => $pager,
            'lastPage' => $lastPage,
            'currentPage' => $page,
            'total' => $total,
            'search' => $search,
            'filter' => $filter,
            'sort' => $sort,
            'order' => $order
        ];

        return view('training/index', $data);
    }
}

